<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.1.1/jquery.min.js"></script>
<script type="text/javascript">
$('.attach').each(function() { // на случай, если таких групп файлов будет больше одной
  var attach = $(this),
    fieldClass = 'attach__item', // класс поля
    attachedClass = 'attach__item--attached', // класс поля с файлом
    fields = attach.find('.' + fieldClass).length, // начальное кол-во полей
    fieldsAttached = 0; // начальное кол-во полей с файлами

  var newItem = '<div class="attach__item"><label><div class="attach__up">Добавить файл</div><input class="attach__input" type="file" name="files[]" /></label><div class="attach__name"></div><div class="attach__edit">Изменить</div><div class="attach__delete">Удалить</div></div>'; // разметка нового поля

  // При изменении инпута
  attach.on('change', '.attach__input', function(e) {
    var item = $(this).closest('.' + fieldClass),
      fileName = '';
    if (e.target.value) { // если value инпута не пустое
      fileName = e.target.value.split('\\').pop(); // оставляем только имя файла и записываем в переменную
    }
    if (fileName) { // если имя файла не пустое
      item.find('.attach__name').text(fileName); // подставляем в поле имя файла
      if (!item.hasClass(attachedClass)) { // если в поле до этого не было файла
        item.addClass(attachedClass); // отмечаем поле классом
        fieldsAttached++;
      }
      if (fields < 10 && fields == fieldsAttached) { // если полей меньше 10 и кол-во полей равно
        item.after($(newItem)); // добавляем новое поле
        fields++;
      }
    } else { // если имя файла пустое
      if (fields == fieldsAttached + 1) {
        item.remove(); // удаляем поле
        fields--;
      } else {
        item.replaceWith($(newItem)); // заменяем поле на "чистое"
      }
      fieldsAttached--;

      if (fields == 1) { // если поле осталось одно
        attach.find('.attach__up').text('Загрузить файл'); // меняем текст
      }
    }
  });

  // При нажатии на "Изменить"
  attach.on('click', '.attach__edit', function() {
    $(this).closest('.attach__item').find('.attach__input').trigger('click'); // имитируем клик на инпут
  });

  // При нажатии на "Удалить"
  attach.on('click', '.attach__delete', function() {
    var item = $(this).closest('.' + fieldClass);
    if (fields > fieldsAttached) { // если полей больше, чем загруженных файлов
      item.remove(); // удаляем поле
      fields--;
    } else { // если равно
      item.after($(newItem)); // добавляем новое поле
      item.remove(); // удаляем старое
    }
    fieldsAttached--;
    if (fields == 1) { // если поле осталось одно
      attach.find('.attach__up').text('Загрузить файл'); // меняем текст
    }
  });
});
</script>

<style>
.attach__head {
  border-bottom: #000 solid 1px;
  text-transform: uppercase;
  font-weight: 700;
  padding: 0 0 5px 0px;
  margin: 0 0 5px 0;
}

.attach__item {
  border-bottom: #ccc solid 1px;
  padding: 0 0 5px 0px;
  margin: 0 0 5px 0;
}

.attach__item:last-of-type {
  margin-bottom: 0px;
  border-bottom: none;
}

.attach__up {
  cursor: pointer;
}

.attach__edit,
.attach__delete {
  display: none;
  margin-right: 10px;
  cursor: pointer;
}

.attach__edit {
  color: #2f7dfe;
}

.attach__delete {
  color: #f00;
}

.attach__item--attached .attach__up {
  display: none;
}

.attach__item--attached .attach__edit,
.attach__item--attached .attach__delete {
  display: inline-block;
}

.attach__input {
  display: none;
}
<script src="https://aja</style>
<form>
  <div class="attach">
    <div class="attach__head">Прикрепите файлы (максимум 10 файлов):</div>
    <div class="attach__item">
      <label>
        <div class="attach__up">Загрузить файл</div>
        <input class="attach__input" type="file" name="files" />
      </label>
      <div class="attach__name"></div>
      <div class="attach__edit">Изменить</div>
      <div class="attach__delete">Удалить</div>
    </div>
  </div>
</form>